library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity WheelDecoder_TB is
end WheelDecoder_TB;

architecture Testbench of WheelDecoder_TB is

	constant SYS_CLK_FREQ	: real := 0.25; -- MHz
	constant SYS_CLK_PERIOD	: time := 1 us / SYS_CLK_FREQ;

	component WheelDecoder is
		generic (CLK_FREQ		: in	integer);
		port (   clk			: in	std_logic;
					reset			: in	std_logic;
					sensorA		: in	std_logic;
					sensorB		: in	std_logic;
					countOut		: out std_logic_vector(15 downto 0));
	end component;

	signal clk			: std_logic;
	signal reset		: std_logic;

	signal sensorA		: std_logic;
	signal sensorB		: std_logic;

	signal countOut	: std_logic_vector(15 downto 0);

begin

Clock : process
begin
	clk <= '0';
	wait for SYS_CLK_PERIOD/2;
	clk <= '1';
	wait for SYS_CLK_PERIOD/2;
end process;

UUT : WheelDecoder
generic map(CLK_FREQ			=> integer(SYS_CLK_FREQ * 1000000.0))
port map (	clk				=> clk,
				reset				=> reset,
				sensorA			=> sensorA,
				sensorB			=> sensorB,
				countOut			=> countOut);

TB : process

begin
	sensorA <= '0';
	sensorB <= '0';
	reset <= '1';

	wait for 100 ns;
	wait until (clk'event and clk='1');
	reset <= '0';

	-- Right
	wait for 2 ms;
	sensorA <= '1';

	wait for 2 ms;
	sensorB <= '1';

	wait for 2 ms;
	sensorA <= '0';

	wait for 2 ms;
	sensorB <= '0';

	-- Left
	wait for 2 ms;
	sensorB <= '1';

	wait for 2 ms;
	sensorA <= '1';

	wait for 2 ms;
	sensorB <= '0';

	wait for 2 ms;
	sensorA <= '0';

	wait;

end process;

end Testbench;

