library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity WheelDecoderFPGATest is
	port (	clkIn			: in	std_logic;
				resetButton	: in	std_logic;
				sensorA		: in	std_logic;
				sensorB		: in	std_logic;
				seg			: out	std_logic_vector(6 downto 0);
				dp				: out	std_logic;
				an				: out	std_logic_vector(3 downto 0));
end WheelDecoderFPGATest;

architecture Test of WheelDecoderFPGATest is

	-- LOCs for Digilent Spartan-3E Development Board
	attribute LOC : string;
	attribute LOC of clkIn			: signal is "B8";    -- 50MHz
	attribute LOC of resetButton	: signal is "B18";   -- BTN3
	attribute LOC of sensorA		: signal is "J14";   -- JD4
	attribute LOC of sensorB		: signal is "P18";   -- JD10

	attribute LOC of seg				: signal is "L18 F18 D17 D16 G14 J17 H14";
	attribute LOC of dp				: signal is "C17";
	attribute LOC of an				: signal is "F15 C18 H17 F17";

	component WheelDecoder is
		generic (CLK_FREQ		: in	integer);
		port (   clk			: in	std_logic;
					reset			: in	std_logic;
					sensorA		: in	std_logic;
					sensorB		: in	std_logic;
					countOut		: out std_logic_vector(15 downto 0));
	end component;

	component SimpleSevenSegDriver is
	port (	clk				: in	std_logic;
				reset				: in	std_logic;
				digit0			: in	std_logic_vector(3 downto 0);
				digit1			: in	std_logic_vector(3 downto 0);
				digit2			: in	std_logic_vector(3 downto 0);
				digit3			: in	std_logic_vector(3 downto 0);
				dpIn				: in	std_logic_vector(3 downto 0);
				seg				: out	std_logic_vector(6 downto 0);
				dp					: out	std_logic;
				an					: out	std_logic_vector(3 downto 0));
	end component;

	signal countOut	: std_logic_vector(15 downto 0);

begin

Decoder : WheelDecoder
generic map(CLK_FREQ	=> integer(5000000))	-- 50 MHz System Clock
port map (	clk		=> clkIn,
				reset		=> resetButton,
				sensorA	=> sensorA,
				sensorB	=> sensorB,
				countOut	=> countOut);

Display : SimpleSevenSegDriver
port map (	clk		=> clkIn,
				reset		=> resetButton,
				digit0	=> countOut(3 downto 0),
				digit1	=> countOut(7 downto 4),
				digit2	=> countOut(11 downto 8),
				digit3	=> countOut(15 downto 12),
				dpIn		=> "0010",
				seg		=> seg,
				dp			=> dp,
				an			=> an);

end Test;
